### Name: Auxiliary functions
### Title: Utilities functions for adegenet objects
### Aliases: truenames .truenames.genind .truenames.genpop seploc
###   .seploc.genind .seploc.genpop
### Keywords: manip

### ** Examples

data(microbov)
# restore true names
truenames(microbov)$tab[1:5,1:5]

# isolate each marker
obj <- seploc(microbov,truenames=TRUE)
names(obj)

# make a new object with INRA5
head(obj$INRA5)
inra5.gind <- as.genind(obj$INRA5)
inra5.gind

# perform tests only on this marker
if(require(genetics)){
hw.test <- HWE.test.genind(inra5.gind,pop=microbov$pop,res.type="matrix",permut=TRUE) 
hw.test
}

if(require(hierfstat)){
g.test <- gstat.randtest(inra5.gind,pop=microbov$pop,nsim=99)
g.test
}



