### Name: genind
### Title: adegenet class for individual genotypes
### Aliases: genind is.genind as.genind print.genind summary.genind
###   genind2genpop .rmspaces .is.gen
### Keywords: manip multivariate

### ** Examples

obj <- genetix2genind(system.file("files/nancycats.gtx",package="adegenet"),missing="mean")
is.genind(obj)
summary(obj)
obj

# test inter-colonies structuration
if(require(hierfstat)){
gtest <- gstat.randtest(obj,nsim=99)
gtest
plot(gtest)
}

# perform an inter-class PCA
if(require(ade4)){
pca1 <- dudi.pca(obj$tab,scannf=FALSE,scale=FALSE)
pcabet1 <- between(pca1,obj$pop,scannf=FALSE)
pcabet1

s.class(pcabet1$ls,obj$pop,sub="Inter-class PCA",possub="topleft",csub=2)
add.scatter.eig(pcabet1$eig,2,xax=1,yax=2)
}



