### Name: genpop
### Title: adegenet class for allele counts in populations
### Aliases: genpop is.genpop as.genpop print.genpop summary.genpop
### Keywords: manip multivariate

### ** Examples

obj1 <- import2genind(system.file("files/nancycats.gen",
package="adegenet"))
is.genpop(obj1)
summary(obj1)
obj1

obj2 <- genind2genpop(obj1)
is.genpop(obj2)
obj2

if(require(ade4)){
data(microsatt)
# use as.genpop to convert convenient count tab to genpop
obj3 <- as.genpop(microsatt$tab)
obj3

all(obj3$tab==microsatt$tab)
all(obj3$pop.names==rownames(microsatt$tab))
# it worked

# perform a correspondance analysis
obj4 <- genind2genpop(obj1,missing="replace")
ca1 <- dudi.coa(as.data.frame(obj4$tab),scannf=FALSE)
s.label(ca1$li,sub="Correspondance Analysis",csub=2)
add.scatter.eig(ca1$eig,2,xax=1,yax=2,posi="top")
}



