### Encoding: UTF-8

### Name: Accessors
### Title: Accessors for adegenet objects
### Aliases: $,genind-method $,genpop-method $<-,genind-method
###   $<-,genpop-method [,genind-method [,genpop-method nLoc
###   nLoc,genind-method nLoc,genpop-method pop pop<- pop,genind-method
###   pop<-,genind-method locNames locNames,genind-method
###   locNames,genpop-method
### Keywords: manip

### ** Examples

data(nancycats)
nancycats
nancycats$pop

# let's isolate populations 4 and 8
temp <- nancycats@pop=="P04" | nancycats@pop=="P08"
obj <- nancycats[temp,]
obj

truenames(obj)$pop

# let's isolate two markers, fca23 and fca90
nancycats$loc.names

# they correspond to L2 and L7
temp <- nancycats$loc.fac=="L2" | nancycats$loc.fac=="L7"
obj <- nancycats[,temp]
obj

obj$loc.fac 
obj$loc.names

# or more simply
nancycats[loc=c("L2","L7")]
obj$loc.fac 
obj$loc.names

# using 'drop':
truenames(nancycats[1:2])$tab
truenames(nancycats[1:2, drop=TRUE])$tab

# illustrate how 'other' slot is handled
colonies <- genind2genpop(nancycats)
colonies@other$aChar <- "This will not be proceeded"
colonies123 <- colonies[1:3]
colonies
colonies@other$xy

# illustrate pop
obj <- nancycats[sample(1:100,10)]
obj$pop
obj$pop.names
pop(obj)
pop(obj) <- rep(c('b','a'), each=5)
obj$pop
obj$pop.names
pop(obj)

# illustrate locNames
locNames(obj)
locNames(obj, withAlleles=TRUE)




