### Name: as methods in adegenet
### Title: Converting genind/genpop objects to other classes
### Aliases: as-method as,genind,data.frame-method
###   as,genpop,data.frame-method as,genind,matrix-method
###   as,genpop,matrix-method as,genind,genpop-method ktab-class
###   as,genind,ktab-method as,genpop,ktab-method
###   coerce,genind,data.frame-method coerce,genpop,data.frame-method
###   coerce,genind,matrix-method coerce,genpop,matrix-method
###   coerce,genind,genpop-method coerce,genind,ktab-method
###   coerce,genpop,ktab-method as.data.frame.genind as.data.frame.genpop
###   as.matrix.genind as.matrix.genpop as.genpop.genind as.ktab.genind
###   as.ktab.genpop
### Keywords: methods

### ** Examples

data(microbov)
x <- na.replace(microbov,method="0")
as(x[1:3],"data.frame")

## dudi functions attempt to convert their first argument
## to a data.frame; so they can be used on genind/genpop objects.
if(require(ade4)){
## perform a PCA
pca1 <- dudi.pca(x, scale=FALSE, scannf=FALSE)
pca1

x <- genind2genpop(microbov,miss="chi2")
x <- as(x,"ktab")
class(x)
## perform a STATIS analysis
statis1 <- statis(x, scannf=FALSE)
statis1
plot(statis1)
}



