### Encoding: UTF-8

### Name: genpop
### Title: adegenet formal class (S4) for allele counts in populations
### Aliases: genpop-class dist,genpop,ANY,ANY,ANY,missing-method
###   names,genpop-method show,genpop-method summary,genpop-method
### Keywords: classes manip multivariate

### ** Examples

obj1 <- import2genind(system.file("files/nancycats.gen",
package="adegenet"))
obj1

obj2 <- genind2genpop(obj1)
obj2

if(require(ade4)){
data(microsatt)
# use as.genpop to convert convenient count tab to genpop
obj3 <- as.genpop(microsatt$tab)
obj3

all(obj3@tab==microsatt$tab)
all(obj3@pop.names==rownames(microsatt$tab))
# it worked

# perform a correspondance analysis
obj4 <- genind2genpop(obj1,missing="chi2")
ca1 <- dudi.coa(as.data.frame(obj4@tab),scannf=FALSE)
s.label(ca1$li,sub="Correspondance Analysis",csub=2)
add.scatter.eig(ca1$eig,2,xax=1,yax=2,posi="top")
}



