### Encoding: UTF-8

### Name: hybridize
### Title: Simulated hybridization between two samples of populations
### Aliases: hybridize
### Keywords: manip

### ** Examples

## Let's make some cattle hybrids
##
data(microbov)

## first, isolate each breed
temp <- seppop(microbov)
names(temp)

salers <- temp$Salers
zebu <- temp$Zebu
borgou <- temp$Borgou
somba <- temp$Somba

## let's make some... Zeblers
zebler <- hybridize(salers, zebu, n=40)

## and some Somgou
somgou <- hybridize(somba, borgou, n=40)

## now let's merge all data into a single genind
newDat <- repool(microbov, zebler, somgou)

## make a correspondance analysis
## and see where hybrids are placed
if(require(ade4)){
X <- genind2genpop(newDat,missing="chi2",quiet=TRUE)
coa1 <- dudi.coa(as.data.frame(X$tab),scannf=FALSE,nf=3)
s.label(coa1$li,label=X$pop.names)
add.scatter.eig(coa1$eig,2,1,2)
}



