### Encoding: UTF-8

### Name: makefreq
### Title: Function to generate allelic frequencies
### Aliases: makefreq
### Keywords: manip multivariate

### ** Examples

data(microbov)
obj1 <- microbov

obj2 <- genind2genpop(obj1)

Xfreq <- makefreq(obj2,missing="mean")

if(require(ade4)){

# perform a correspondance analysis on counts data

Xcount <- genind2genpop(obj1,missing="chi2")
ca1 <- dudi.coa(as.data.frame(Xcount@tab),scannf=FALSE)
s.label(ca1$li,sub="Correspondance Analysis",csub=1.2)
add.scatter.eig(ca1$eig,nf=2,xax=1,yax=2,posi="topleft")

# perform a principal component analysis on frequency data
pca1 <- dudi.pca(Xfreq$tab,scale=FALSE,scannf=FALSE)
s.label(pca1$li,sub="Principal Component Analysis",csub=1.2)
add.scatter.eig(pca1$eig,nf=2,xax=1,yax=2,posi="top")
}



