### Name: na.replace-methods
### Title: Replace missing values (NA) from an object
### Aliases: na.replace na.replace-methods na.replace,genind-method
###   na.replace,genpop-method
### Keywords: methods manip

### ** Examples

data(nancycats)

obj1 <- genind2genpop(nancycats)
# note missing data in this summary
summary(obj1)

# NA are all in pop 17 and marker fca45
which(is.na(obj1$tab),TRUE)
truenames(obj1)[17,]

# replace missing values
obj2 <- na.replace(obj1,"chi2")
obj2$loc.names

# missing values where replaced
truenames(obj2)[,obj2$loc.fac=="L4"]



