### Encoding: UTF-8

### Name: nancycats
### Title: Microsatellites genotypes of 237 cats from 17 colonies of Nancy
###   (France)
### Aliases: nancycats
### Keywords: datasets

### ** Examples

data(nancycats)
nancycats

# summary's results are stored in x
x <- summary(nancycats)

# some useful graphics
barplot(x$loc.nall,ylab="Alleles numbers",main="Alleles numbers
per locus")

plot(x$pop.eff,x$pop.nall,type="n",xlab="Sample size",ylab="Number of alleles")
text(x$pop.eff,y=x$pop.nall,lab=names(x$pop.nall))

par(las=3)
barplot(table(nancycats@pop),ylab="Number of genotypes",main="Number of genotypes per colony")

# are cats structured among colonies ?
if(require(hierfstat)){

if(require(ade4)){
gtest <- gstat.randtest(nancycats,nsim=99)
gtest
plot(gtest)
}

dat <- genind2hierfstat(nancycats)

Fstat <- varcomp.glob(dat$pop,dat[,-1])
Fstat
}



