### Encoding: UTF-8

### Name: propShared
### Title: Compute proportion of shared alleles
### Aliases: propShared
### Keywords: manip multivariate

### ** Examples

## make a small object
data(microbov)
obj <- microbov[1:5,microbov@loc.fac %in% c("L01","L02")]

## verify results
propShared(obj)
genind2df(obj,sep="|")

## Use this similarity measure inside a PCoA
## This is for illustration only:
## the distance should be rendered Euclidean before
## (e.g. using quasieuclid from package ade4).
if(require(ade4)){
matSimil <- propShared(microbov)
matDist <- exp(-matSimil)
D <- as.dist(matDist)
pcoa1 <- dudi.pco(D,scannf=FALSE,nf=3)
s.class(pcoa1$li,microbov$pop,lab=microbov$pop.names)
}



