### R code from vignette source 'adegenet-genomics.Rnw'
### Encoding: ASCII

###################################################
### code chunk number 1: adegenet-genomics.Rnw:105-107
###################################################
library(adegenet)
getClassDef("SNPbin")


###################################################
### code chunk number 2: adegenet-genomics.Rnw:121-122
###################################################
new("SNPbin")


###################################################
### code chunk number 3: adegenet-genomics.Rnw:128-130
###################################################
x <- new("SNPbin", c(0,1,1,2,0,0,1))
x


###################################################
### code chunk number 4: adegenet-genomics.Rnw:136-139
###################################################
x
ploidy(x) <- 3
x


###################################################
### code chunk number 5: adegenet-genomics.Rnw:143-144
###################################################
x@snp


###################################################
### code chunk number 6: adegenet-genomics.Rnw:147-148
###################################################
as.integer(x)


###################################################
### code chunk number 7: adegenet-genomics.Rnw:155-159
###################################################
dat <- sample(0:1, 1e6, replace=TRUE)
print(object.size(dat),unit="auto")
x <- new("SNPbin", dat)
print(object.size(x),unit="auto")


###################################################
### code chunk number 8: adegenet-genomics.Rnw:164-165
###################################################
identical(as.integer(x),dat)


###################################################
### code chunk number 9: adegenet-genomics.Rnw:190-191
###################################################
getClassDef("genlight")


###################################################
### code chunk number 10: adegenet-genomics.Rnw:213-214
###################################################
new("genlight")


###################################################
### code chunk number 11: adegenet-genomics.Rnw:227-230
###################################################
x <- new("genlight", list(indiv1=c(1,1,0,1,1,0), indiv2=c(2,1,1,0,0,0), toto=c(2,2,0,0,4,4)))
x
ploidy(x)


###################################################
### code chunk number 12: adegenet-genomics.Rnw:235-237
###################################################
as.list(x)
as.matrix(x)


###################################################
### code chunk number 13: adegenet-genomics.Rnw:244-252
###################################################
dat <- lapply(1:50, function(i) sample(c(0,1,NA), 1e6, prob=c(.5, .499, .001), replace=TRUE))
names(dat) <- paste("indiv", 1:length(dat))
print(object.size(dat),unit="auto")

x <- new("genlight", dat)
print(object.size(x),unit="auto")

object.size(dat)/object.size(x)


###################################################
### code chunk number 14: adegenet-genomics.Rnw:277-278
###################################################
rm(dat)


###################################################
### code chunk number 15: adegenet-genomics.Rnw:316-326
###################################################
dat <- lapply(1:3, function(i) sample(0:2, 10, replace=TRUE))
dat
x <- new("genlight", dat)
x
indNames(x)
indNames(x) <- paste("individual", 1:3)
indNames(x)
locNames(x)
locNames(x) <- paste("SNP",1:nLoc(x),sep=".")
as.matrix(x)


###################################################
### code chunk number 16: adegenet-genomics.Rnw:341-342
###################################################
x


###################################################
### code chunk number 17: adegenet-genomics.Rnw:345-346 (eval = FALSE)
###################################################
## chr(x) <- rep("chr-1", 7)


###################################################
### code chunk number 18: adegenet-genomics.Rnw:349-352
###################################################
chr(x) <- rep("chr-1", 10)
x
chr(x)


###################################################
### code chunk number 19: adegenet-genomics.Rnw:367-372
###################################################
x
as.matrix(x)
as.matrix(x[c(1,3),])
as.matrix(x[, c(TRUE,FALSE)])
as.matrix(x[1:2, c(1,1,1,2,2,2,3,3,3)])


###################################################
### code chunk number 20: adegenet-genomics.Rnw:382-386
###################################################
x
as.matrix(x)
seploc(x, n.block=2)
lapply(seploc(x, n.block=2),as.matrix)


###################################################
### code chunk number 21: adegenet-genomics.Rnw:389-390
###################################################
lapply(seploc(x, n.block=2, random=TRUE),as.matrix)


###################################################
### code chunk number 22: adegenet-genomics.Rnw:415-416 (eval = FALSE)
###################################################
## file.show(system.file("files/exampleSnpDat.snp",package="adegenet"))


###################################################
### code chunk number 23: adegenet-genomics.Rnw:493-499
###################################################
obj <- read.snp(system.file("files/exampleSnpDat.snp",package="adegenet"), chunk=2)
obj
as.matrix(obj)
alleles(obj)
pop(obj)
indNames(obj)


###################################################
### code chunk number 24: adegenet-genomics.Rnw:503-504 (eval = FALSE)
###################################################
## obj <- read.snp("path-to-my-file.snp")


###################################################
### code chunk number 25: adegenet-genomics.Rnw:555-558
###################################################
myPath <- system.file("files/usflu.fasta",package="adegenet")
flu <- fasta2genlight(myPath, chunk=10)
flu


###################################################
### code chunk number 26: adegenet-genomics.Rnw:566-569
###################################################
head(position(flu), 20)
head(alleles(flu), 20)
head(locNames(flu), 20)


###################################################
### code chunk number 27: adegenet-genomics.Rnw:574-578
###################################################
temp <- density(position(flu), bw=10)
plot(temp, type="n", xlab="Position in the alignment", main="Location of the SNPs", xlim=c(0,1701))
polygon(c(temp$x,rev(temp$x)), c(temp$y, rep(0,length(temp$x))), col=transp("blue",.3))
points(position(flu), rep(0, nLoc(flu)), pch="|", col="blue")


###################################################
### code chunk number 28: adegenet-genomics.Rnw:590-592
###################################################
flu <- fasta2genlight(myPath, chunk=10,saveNbAlleles=TRUE, quiet=TRUE)
flu


###################################################
### code chunk number 29: adegenet-genomics.Rnw:597-599
###################################################
head(other(flu)$nb.all.per.loc, 20)
100*mean(unlist(other(flu))>1)


###################################################
### code chunk number 30: adegenet-genomics.Rnw:605-608
###################################################
temp <- table(unlist(other(flu)))
barplot(temp, main="Distribution of the number \nof alleles per loci",
        xlab="Number of alleles", ylab="Number of sites", col=heat.colors(4))


###################################################
### code chunk number 31: adegenet-genomics.Rnw:613-616
###################################################
temp <- temp[-1]
temp <- 100*temp/sum(temp)
round(temp,1)


###################################################
### code chunk number 32: adegenet-genomics.Rnw:656-657
###################################################
glPlot(flu, posi="topleft")


###################################################
### code chunk number 33: adegenet-genomics.Rnw:665-666 (eval = FALSE)
###################################################
## x <- glSim(100, 0, 100, ploidy=2)


###################################################
### code chunk number 34: adegenet-genomics.Rnw:668-669 (eval = FALSE)
###################################################
## plot(x)


###################################################
### code chunk number 35: adegenet-genomics.Rnw:676-677 (eval = FALSE)
###################################################
## x <- glSim(100, 100, ploidy=2, LD=TRUE, block.size=10)


###################################################
### code chunk number 36: adegenet-genomics.Rnw:679-680 (eval = FALSE)
###################################################
## plot(x)


###################################################
### code chunk number 37: adegenet-genomics.Rnw:719-723
###################################################
myFreq <- glMean(flu)
hist(myFreq, proba=TRUE, col="gold", xlab="Allele frequencies", main="Distribution of (second) allele frequencies")
temp <- density(myFreq)
lines(temp$x, temp$y*1.8,lwd=3)


###################################################
### code chunk number 38: adegenet-genomics.Rnw:729-734
###################################################
myFreq <- glMean(flu)
myFreq <- c(myFreq, 1-myFreq)
hist(myFreq, proba=TRUE, col="darkseagreen3", xlab="Allele frequencies", main="Distribution of allele frequencies", nclass=20)
temp <- density(myFreq, bw=.05)
lines(temp$x, temp$y*2,lwd=3)


###################################################
### code chunk number 39: adegenet-genomics.Rnw:754-759
###################################################
head(glNA(flu),20)
temp <- density(glNA(flu), bw=10)
plot(temp, type="n", xlab="Position in the alignment", main="Location of the missing values (NAs)", xlim=c(0,1701))
polygon(c(temp$x,rev(temp$x)), c(temp$y, rep(0,length(temp$x))), col=transp("blue",.3))
points(glNA(flu), rep(0, nLoc(flu)), pch="|", col="blue")


###################################################
### code chunk number 40: adegenet-genomics.Rnw:787-789
###################################################
x <- glSim(40, 1e5, LD=FALSE)
x


###################################################
### code chunk number 41: adegenet-genomics.Rnw:792-796
###################################################
x <- seploc(x, n.block=10)
class(x)
names(x)
x[1:2]


###################################################
### code chunk number 42: adegenet-genomics.Rnw:800-804
###################################################
lD <- lapply(x, function(e) dist(as.matrix(e)))
class(lD)
names(lD)
class(lD[[1]])


###################################################
### code chunk number 43: adegenet-genomics.Rnw:808-809
###################################################
D <- Reduce("+", lD)


###################################################
### code chunk number 44: adegenet-genomics.Rnw:812-815
###################################################
library(ape)
plot(nj(D), type="fan")
title("A simple NJ tree of simulated genlight data")


###################################################
### code chunk number 45: adegenet-genomics.Rnw:837-841
###################################################
x <- new("genlight", list(a=c(0,0,1,1), b=c(1,1,0,0), c=c(1,1,1,1)))
locNames(x) <- 1:4
x
as.matrix(x)


###################################################
### code chunk number 46: adegenet-genomics.Rnw:845-846
###################################################
glMean(x)


###################################################
### code chunk number 47: adegenet-genomics.Rnw:849-854
###################################################
x <- new("genlight", list(a=c(0,0,2,2), b=c(1,1,0,0), c=c(1,1,1,1)))
locNames(x) <- 1:4
x
as.matrix(x)
ploidy(x)


###################################################
### code chunk number 48: adegenet-genomics.Rnw:871-873
###################################################
M <- as.matrix(x)/ ploidy(x)
apply(M,2,mean)


###################################################
### code chunk number 49: adegenet-genomics.Rnw:881-884
###################################################
as.matrix(x)
glMean(x, alleleAsUnit=TRUE)
glMean(x, alleleAsUnit=FALSE)


###################################################
### code chunk number 50: adegenet-genomics.Rnw:900-902 (eval = FALSE)
###################################################
## flu
## pca1 <- glPca(flu)


###################################################
### code chunk number 51: adegenet-genomics.Rnw:904-905
###################################################
load("Robjects/pca1.RData")


###################################################
### code chunk number 52: adegenet-genomics.Rnw:914-915
###################################################
pca1


###################################################
### code chunk number 53: adegenet-genomics.Rnw:922-924
###################################################
scatter(pca1, posi="bottomright")
title("PCA of the US influenza data\n axes 1-2")


###################################################
### code chunk number 54: adegenet-genomics.Rnw:929-934
###################################################
library(ape)
tre <- nj(dist(as.matrix(flu)))
tre
plot(tre, typ="fan", cex=0.7)
title("NJ tree of the US influenza data")


###################################################
### code chunk number 55: adegenet-genomics.Rnw:939-942
###################################################
myCol <- colorplot(pca1$scores,pca1$scores, transp=TRUE, cex=4)
abline(h=0,v=0, col="grey")
add.scatter.eig(pca1$eig[1:40],2,1,2, posi="topright", inset=.05, ratio=.3)


###################################################
### code chunk number 56: adegenet-genomics.Rnw:945-948
###################################################
plot(tre, typ="fan", show.tip=FALSE)
tiplabels(pch=20, col=myCol, cex=4)
title("NJ tree of the US influenza data")


###################################################
### code chunk number 57: adegenet-genomics.Rnw:971-974
###################################################
x <- glSim(100, 5e4, 50)
x
dapc1 <- dapc(x, n.pca=20, n.da=1)


###################################################
### code chunk number 58: adegenet-genomics.Rnw:980-981
###################################################
scatter(dapc1,scree.da=FALSE, bg="white", posi.pca="topright", legen=TRUE, txt.leg=paste("group", 1:2), col=c("red","blue"))


###################################################
### code chunk number 59: adegenet-genomics.Rnw:985-986
###################################################
compoplot(dapc1, col=c("red","blue"),lab="", txt.leg=paste("group", 1:2), ncol=2)


###################################################
### code chunk number 60: adegenet-genomics.Rnw:990-991 (eval = FALSE)
###################################################
## loadingplot(dapc1$var.contr, thres=4e-4)


###################################################
### code chunk number 61: adegenet-genomics.Rnw:1000-1001
###################################################
loadingplot(tail(dapc1$var.contr[,1],100))


